#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>

//#include "stdemace.h"
#include "msggetthread.h"

QT_BEGIN_NAMESPACE
namespace Ui { class MainWindow; }
QT_END_NAMESPACE

/* define data blocks */
#define DBLK1   1
#define DBLK2   2
#define DBLK3   3
#define DBLK4   4

/* define message constants */
#define MSG1    1
#define MSG2    2
#define MSG3    3
#define MSG4    4

/* define opcodes */
#define OP1     1
#define OP2     2
#define OP3     3
#define OP4     4

#define OPCAL1  100
#define OPCAL2  101

/* define frame constants */
#define MNR1    1
#define MNR2    2
#define MJR		100

typedef struct
{
    U8BIT rtAddr;
    U8BIT TR;
    U8BIT subAddr;
    U8BIT wordCnt;
}MSG_PARAMS;

#define NO_OF_MSGS	4

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow(QWidget *parent = nullptr);
    ~MainWindow();

    int m_devNum;
    MSG_PARAMS m_MsgPara[4] = { {1, 0, 1, 0},
                                    {1, 1, 2, 0},
                                    {3, 0, 3, 0},
                                    {3, 1, 4, 0}, };

protected:
     void closeEvent(QCloseEvent *event);

private slots:
    void on_pushButton_InitBC_clicked();

    void ProcessNewHbufMsgAvlbl(int msgNum, MSGSTRUCT strMsg);

    void on_pushButton_StartBC_clicked();

    void on_pushButton_StopBC_clicked();

    void on_pushButton_FreeChannel_clicked();

    void on_pushButton_Close_clicked();

    void on_pushButton_Write_clicked();

private:
    Ui::MainWindow *ui;
    msgGetThread m_msgGetThread;

    QString CreateDisplayString(MSGSTRUCT* pMsg);
};
#endif // MAINWINDOW_H
