#include "msggetthread.h"
#include "mainwindow.h"

msgGetThread::msgGetThread(QObject *parent)
    : QThread{parent}
{

}

void msgGetThread::SetPtr(MainWindow *pMainWindow)
{
    pMsgGetMainWindow = pMainWindow;
}

void msgGetThread::run()
{
    S16BIT nResult = 0x0000;
    U32BIT dwMsgCount = 0x00000000;
    U32BIT dwHBufLost = 0x00000000;
    U32BIT dwCurCount = 0x00000000;
    MSGSTRUCT sMsg;

    isThreadStopped = false;
    qDebug() << "\n++++++++++++++++ Started msgGetThread::run !!!!!!!!!!!!!!!\n";

    while (!this->stop)
    {
        /* Check host buffer for msgs */
        nResult = aceBCGetHBufMsgDecoded(pMsgGetMainWindow->m_devNum, &sMsg, &dwMsgCount, &dwHBufLost, ACE_BC_MSGLOC_NEXT_PURGE);

        if (nResult)
        {
            /* Error reading HBuf */
            continue;
        }

        /* Message found */
        if (dwMsgCount)
        {
            /* Update total messages counter */
            ++dwCurCount;

            /* Analyze the command word to identify this message */
            U16BIT RT = 0, TR = 0, SA = 0, WC = 0;
            nResult = aceCmdWordParse(sMsg.wCmdWrd1, &RT, &TR, &SA, &WC);

            /* Based on the message identified, save MSGSTRUCT and notify GUI */
            for (int i = 0; i < NO_OF_MSGS; i++)
            {
                if (RT == pMsgGetMainWindow->m_MsgPara[i].rtAddr && TR == pMsgGetMainWindow->m_MsgPara[i].TR && SA == pMsgGetMainWindow->m_MsgPara[i].subAddr && WC == pMsgGetMainWindow->m_MsgPara[i].wordCnt)	// MSG1
                {
                    /* Notify GUI thread */
                    emit NewHbufMsgAvlbl(i, sMsg);
                }
            }
        }

        QThread::msleep(1);
    }

    isThreadStopped = true;

    qDebug() << "\n++++++++++++++++ Quitting msgGetThread::run !!!!!!!!!!!!!!!\n";
}

bool msgGetThread::IsThreadStopped()
{
    return isThreadStopped;
}
