#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>

#include "msggetthread.h"

QT_BEGIN_NAMESPACE
namespace Ui { class MainWindow; }
QT_END_NAMESPACE

/* define data blocks */
#define RX_DBLK_BASE	1
#define TX_DBLK_BASE	33

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow(QWidget *parent = nullptr);
    ~MainWindow();

    int m_devNum;
    int m_RTAddr;

protected:
     void closeEvent(QCloseEvent *event);

private slots:
     void on_pushButton_InitRT_clicked();

     void on_pushButton_StartRT_clicked();

     void on_pushButton_StopRT_clicked();

     void on_pushButton_FreeChannel_clicked();

     void ProcessNewHbufMsgAvlbl(int msgNum, MSGSTRUCT strMsg);

     void on_pushButton_AddSA_clicked();

     void on_pushButton_RemoveSA_clicked();

     void on_pushButton_AddTxSA_clicked();

     void on_pushButton_RemoveTxSA_clicked();

     void on_pushButton_Close_clicked();

     void on_pushButton_Write_clicked();

private:
    Ui::MainWindow *ui;
    msgGetThread m_msgGetThread;

    QString CreateDisplayString(int msgNum, MSGSTRUCT* pMsg);
};
#endif // MAINWINDOW_H
