#include "msggetthread.h"
#include "mainwindow.h"

msgGetThread::msgGetThread(QObject *parent)
    : QThread{parent}
{

}

void msgGetThread::SetPtr(MainWindow *pMainWindow)
{
    pMsgGetMainWindow = pMainWindow;
}

void msgGetThread::run()
{
    S16BIT nResult = 0x0000;
    U32BIT nMsgNum = 0x0000;
    MSGSTRUCT sMsg;

    isThreadStopped = false;
    qDebug() << "\n++++++++++++++++ Started msgGetThread::run !!!!!!!!!!!!!!!\n";

    while (!this->stop)
    {
        /* Check for RT msgs */
        nResult = aceRTGetStkMsgDecoded(pMsgGetMainWindow->m_devNum, &sMsg, ACE_RT_MSGLOC_NEXT_PURGE);

        /* Message found */
        if (nResult == 1)
        {
            /* Update total messages counter */
            ++nMsgNum;

            /* Notify GUI thread */
            emit NewHbufMsgAvlbl(nMsgNum, sMsg);
        }

        QThread::msleep(1);
    }

    isThreadStopped = true;

    qDebug() << "\n++++++++++++++++ Quitting msgGetThread::run !!!!!!!!!!!!!!!\n";
}

bool msgGetThread::IsThreadStopped()
{
    return isThreadStopped;
}
