/******************************************************************************
 *
 * RTips Technologies, Bangalore (www.rtipsonline.com)
 *
 * This sample demonstrates using DDC's AceXtreme SDK in a MS VC++ MFC
 * GUI application.
 *
 * Many portions of this file are adapted from the rtpoll.c sample provided in
 * the AceXtreme SDK (BU-69092Sx) of M/s. Data Device Corporation
 *
 * This sample demonstrates using DDC's AceXtreme SDK in a MS VC++ MFC GUI application.
 * The sample runs the Enhanced-Mini-ACE in RT mode. Using simple polling, the stack 
 * is queried for messages and read off as found. It displays the messages in a rich text box.
 * It allows the user to specify the RT address and sub addresses. Lastly, it demonstrates the 
 * aceRTDataBlkWrite API to update data.
 *	API's demonstrated in this sample
 *	aceInitialize
 *  aceRTDataBlkCreate
 *  aceRTSetAddress
 *  aceRTDataBlkMapToSA
 *  aceRTMsgLegalityEnable
 *  aceRTGetAddress
 *	aceRTStart
 *	aceRTGetStkMsgDecoded
 *	aceCmdWordParse
 *	aceRTStop
 *	aceFree
 *  aceErrorStr
 *  aceGetMsgTypeString
 *  aceGetBSWErrString
 *  aceRTDataBlkWrite
 *
 * Author: Subhashini B S
 * Last updated: Jan 06, 2025
 ******************************************************************************/

#include "pch.h"
#include "framework.h"
#include "rtpoll_mfc_gui.h"
#include "rtpoll_mfc_guiDlg.h"
#include "afxdialogex.h"
#include <algorithm>

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

/****** Globals *****/
DWORD         dwIdThreadMsgGet;
HANDLE		  hThreadMsgGet;
BOOL		  quitThread = FALSE;
MSGSTRUCT gMsg;

#define WM_PROCESS_NEW_HBUF_MSG_AVLBL (WM_USER + 1)

DWORD WINAPI ThreadMsgGet(LPVOID lpParam);


// CAboutDlg dialog used for App About

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

// Dialog Data
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_ABOUTBOX };
#endif

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(IDD_ABOUTBOX)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


// CrtpollmfcguiDlg dialog



CrtpollmfcguiDlg::CrtpollmfcguiDlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_RTPOLL_MFC_GUI_DIALOG, pParent)
	, m_DataToWrite(0)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CrtpollmfcguiDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO_LDN, m_ComboBoxLDN);
	DDX_Control(pDX, IDC_COMBO_RTADDR, m_ComboBoxRTAddr);
	DDX_Control(pDX, IDC_BUTTON_INIT_RT, m_BtnInitRT);
	DDX_Control(pDX, IDC_BUTTON_START_RT, m_BtnStartRT);
	DDX_Control(pDX, IDC_BUTTON_STOP_RT, m_BtnStopRT);
	DDX_Control(pDX, IDC_BUTTON_FREE_RT, m_BtnFreeRT);
	DDX_Control(pDX, IDC_RICHEDIT_MSG, m_RecMsgDisplay);
	DDX_Control(pDX, IDC_LIST_AVLBL_SA, m_ListAvlblSA);
	DDX_Control(pDX, IDC_LIST_USED_SA, m_ListUsedSA);
	DDX_Control(pDX, IDC_BUTTON_ADD_SA, m_BtnAddSA);
	DDX_Control(pDX, IDC_BUTTON_REMOVE_SA, m_BtnRemoveSA);
	DDX_Control(pDX, IDC_EDIT_DATA_TO_WRITE, m_editDataToWrite);
	DDX_Text(pDX, IDC_EDIT_DATA_TO_WRITE, m_DataToWrite);
	DDX_Control(pDX, IDC_BUTTON_WRITE, m_BtnWrite);
	DDX_Control(pDX, IDC_LIST_AVLBL_TX_SA, m_ListAvlblTxSA);
	DDX_Control(pDX, IDC_LIST_USED_TX_SA, m_ListUsedTxSA);
	DDX_Control(pDX, IDC_BUTTON_ADD_TX_SA, m_BtnAddTxSA);
	DDX_Control(pDX, IDC_BUTTON_REMOVE_TX_SA, m_BtnRemoveTxSA);
}

BEGIN_MESSAGE_MAP(CrtpollmfcguiDlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON_INIT_RT, &CrtpollmfcguiDlg::OnBnClickedButtonInitRt)
	ON_BN_CLICKED(IDC_BUTTON_START_RT, &CrtpollmfcguiDlg::OnBnClickedButtonStartRt)
	ON_BN_CLICKED(IDC_BUTTON_STOP_RT, &CrtpollmfcguiDlg::OnBnClickedButtonStopRt)
	ON_BN_CLICKED(IDC_BUTTON_FREE_RT, &CrtpollmfcguiDlg::OnBnClickedButtonFreeRt)
	ON_BN_CLICKED(IDCANCEL, &CrtpollmfcguiDlg::OnBnClickedCancel)
	ON_MESSAGE(WM_PROCESS_NEW_HBUF_MSG_AVLBL, &CrtpollmfcguiDlg::OnNewHbufMsgAvailable)
	ON_BN_CLICKED(IDC_BUTTON_ADD_SA, &CrtpollmfcguiDlg::OnBnClickedButtonAddSa)
	ON_BN_CLICKED(IDC_BUTTON_REMOVE_SA, &CrtpollmfcguiDlg::OnBnClickedButtonRemoveSa)
	ON_BN_CLICKED(IDC_BUTTON_WRITE, &CrtpollmfcguiDlg::OnBnClickedButtonWrite)
	ON_BN_CLICKED(IDC_BUTTON_ADD_TX_SA, &CrtpollmfcguiDlg::OnBnClickedButtonAddTxSa)
	ON_BN_CLICKED(IDC_BUTTON_REMOVE_TX_SA, &CrtpollmfcguiDlg::OnBnClickedButtonRemoveTxSa)
END_MESSAGE_MAP()


// CrtpollmfcguiDlg message handlers

BOOL CrtpollmfcguiDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != nullptr)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	m_BtnFreeRT.EnableWindow(false);
	m_BtnInitRT.EnableWindow(true);
	m_BtnAddSA.EnableWindow(true);
	m_BtnRemoveSA.EnableWindow(true);
	m_BtnStopRT.EnableWindow(false);
	m_BtnStartRT.EnableWindow(false);
	m_BtnWrite.EnableWindow(false);
	m_BtnAddTxSA.EnableWindow(true);
	m_BtnRemoveTxSA.EnableWindow(true);

	m_ComboBoxLDN.SetCurSel(0);
	m_ComboBoxRTAddr.SetCurSel(1);

	SetWindowText(_T("RTips Technologies - rtpoll GUI sample using MS VC++"));

	CString strSANum;
	for (int saNum=0; saNum<32; saNum++)
	{
		strSANum.Format("%d", saNum);
		m_ListAvlblSA.AddString(strSANum);
		m_ListAvlblTxSA.AddString(strSANum);
	}

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CrtpollmfcguiDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CrtpollmfcguiDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CrtpollmfcguiDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


void CrtpollmfcguiDlg::OnBnClickedButtonInitRt()
{
	/* Variable Definition */
	S16BIT wResult = 0x0000;
	/* Buffer containing data for initial values of data blocks */
/*	U16BIT wBuffer[32] =
	{
		0x0001, 0x0002, 0x0003, 0x0004, 0x0001, 0x0002, 0x0003, 0x0004,
		0x0001, 0x0002, 0x0003, 0x0004, 0x0001, 0x0002, 0x0003, 0x0004,
		0x0001, 0x0002, 0x0003, 0x0004, 0x0001, 0x0002, 0x0003, 0x0004,
		0x0001, 0x0002, 0x0003, 0x0004, 0x0001, 0x0002, 0x0003, 0x0004
	};*/
	U16BIT wBufferRx[32][32];	// 32 buffers for Rx SAs
	U16BIT wBufferTx[32][32];	// 32 buffers for Tx SAs
	int i, j;
	int numRxSA, numTxSA;

	numRxSA = m_ListUsedSA.GetCount();
	if (numRxSA == 0)
	{
		MessageBox(_T("Atleast one Rx SubAddress should be used!"), NULL, MB_OK);
		return;
	}

	numTxSA = m_ListUsedTxSA.GetCount();
	if (numTxSA == 0)
	{
		MessageBox(_T("Atleast one Tx SubAddress should be used!"), NULL, MB_OK);
		return;
	}

	for (i = 0; i < 32; i++)
	{
		for (j = 0; j < 32; j++)
		{
			wBufferRx[i][j] = j;
			wBufferTx[i][j] = j;
		}
	}

	/* Get Logical Device # */
	m_LDN = m_ComboBoxLDN.GetCurSel();

	/* Initialize Device */
	wResult = aceInitialize(m_LDN, ACE_ACCESS_CARD, ACE_MODE_RT, 0, 0, 0);
	if (wResult)
	{
		MessageBox(_T("aceInitialize Failed"), NULL, MB_OK);
		return;
	}

	/* Get RT Address */
	m_RTAddr = m_ComboBoxRTAddr.GetCurSel();

	/* Create DBLKs for RT */
	//aceRTDataBlkCreate(m_LDN, DBLK3, ACE_RT_DBLK_SINGLE, wBuffer, 32);
	for (i = 0; i < 32; i++)
	{
		aceRTDataBlkCreate(m_LDN, RX_DBLK_BASE + i, ACE_RT_DBLK_SINGLE, wBufferRx[i], 32);
		aceRTDataBlkCreate(m_LDN, TX_DBLK_BASE + i, ACE_RT_DBLK_SINGLE, wBufferTx[i], 32);
	}

	/* Set RT [or latch (BU-65565 only)] address */
	aceRTSetAddress(m_LDN, m_RTAddr);

	CString strSA;
	int intSA;
	for (int saCtr = 0; saCtr < numRxSA; saCtr++)
	{
		m_ListUsedSA.GetText(saCtr, strSA);
		intSA = _ttoi(strSA);

		strSA.Format("%d", intSA);

		//MessageBox(_T(strSA), NULL, MB_OK);

		/* Map data block to given Rx sub-address */
		//aceRTDataBlkMapToSA(m_LDN, DBLK3, intSA, ACE_RT_MSGTYPE_ALL, 0, TRUE);
		aceRTDataBlkMapToSA(m_LDN, RX_DBLK_BASE + intSA, intSA, ACE_RT_MSGTYPE_RX, 0, TRUE);

		/*
		   aceRTMsgLegalityEnable function has been added
		   in order to receive a proper response from any
		   RT address configured.
		*/
		//aceRTMsgLegalityEnable(m_LDN, ACE_RT_OWN_ADDRESS, ACE_RT_MODIFY_ALL, intSA, 0xFFFFFFFF);
		aceRTMsgLegalityEnable(m_LDN, ACE_RT_OWN_ADDRESS, 0 /* 0 for receive */, intSA, 0xFFFFFFFF);
	}

	for (int saCtr = 0; saCtr < numTxSA; saCtr++)
	{
		m_ListUsedTxSA.GetText(saCtr, strSA);
		intSA = _ttoi(strSA);

		strSA.Format("%d", intSA);

		//MessageBox(_T(strSA), NULL, MB_OK);

		/* Map data block to given Tx sub-address */
		aceRTDataBlkMapToSA(m_LDN, TX_DBLK_BASE + intSA, intSA, ACE_RT_MSGTYPE_TX, 0, TRUE);

		/*
		   aceRTMsgLegalityEnable function has been added
		   in order to receive a proper response from any
		   RT address configured.
		*/
		aceRTMsgLegalityEnable(m_LDN, ACE_RT_OWN_ADDRESS, 1 /* 1 for transmit */, intSA, 0xFFFFFFFF);
	}


	/* Check that RT Address was set */
	aceRTGetAddress(m_LDN, (U16BIT *) &m_RTAddr);

	m_BtnStartRT.EnableWindow(true);
	m_BtnFreeRT.EnableWindow(true);
	m_BtnInitRT.EnableWindow(false);
	m_BtnAddSA.EnableWindow(false);
	m_BtnRemoveSA.EnableWindow(false);
	m_BtnAddTxSA.EnableWindow(false);
	m_BtnRemoveTxSA.EnableWindow(false);
	m_BtnStopRT.EnableWindow(false);
	m_BtnWrite.EnableWindow(false);
}


void CrtpollmfcguiDlg::OnBnClickedButtonStartRt()
{
	int wResult;

	quitThread = FALSE;

	/* Start RT Device */
	wResult = aceRTStart(m_LDN);
	if (wResult)
	{
		char strBuf[250];
		aceErrorStr(wResult, strBuf, 250);
		CString msg;
		msg.Format(_T("RTStart Failed: %s"), strBuf);
		MessageBox(msg, NULL, MB_OK);
		return;
	}

	/* Change state of buttons */
	m_BtnStopRT.EnableWindow(true);
	m_BtnStartRT.EnableWindow(false);
	m_BtnFreeRT.EnableWindow(false);
	m_BtnWrite.EnableWindow(true);

	// Clear the message display rich edit
	m_RecMsgDisplay.SetWindowTextA(_T(""));

	/* Create a thread to read RT msgs */
	hThreadMsgGet = CreateThread(NULL,			/* default security attributes  */
		0,										/* use default stack size       */
		(LPTHREAD_START_ROUTINE)ThreadMsgGet,	/* thread function   */
		(LPVOID)this,							/* no thread function argument  */
		0,										/* use default creation flags   */
		&dwIdThreadMsgGet);

	if (hThreadMsgGet == NULL)
	{
		AfxMessageBox(_T("CreateThread for hThreadMsgGet Failed!"));
	}
}


void CrtpollmfcguiDlg::OnBnClickedButtonStopRt()
{
	int wResult;

	/* Stop Thread */
	quitThread = TRUE;

	/* Wait for a while to allow the thread to exit */
	Sleep(100);

	/* Stop RT Device */
	wResult = aceRTStop(m_LDN);
	if (wResult)
	{
		MessageBox(_T("RTStop Failed"), NULL, MB_OK);
		return;
	}

	/* Change state of buttons */
	m_BtnStopRT.EnableWindow(false);
	m_BtnStartRT.EnableWindow(true);
	m_BtnFreeRT.EnableWindow(true);
	m_BtnWrite.EnableWindow(false);
}


void CrtpollmfcguiDlg::OnBnClickedButtonFreeRt()
{
	/* Free Ace Memory and Device */
	S16BIT wResult = aceFree(m_LDN);
	if (wResult)
	{
		MessageBox(_T("aceFree Failed"), NULL, MB_OK);
		return;
	}

	/* Change state of buttons */
	m_BtnFreeRT.EnableWindow(false);
	m_BtnInitRT.EnableWindow(true);
	m_BtnAddSA.EnableWindow(true);
	m_BtnRemoveSA.EnableWindow(true);
	m_BtnAddTxSA.EnableWindow(true);
	m_BtnRemoveTxSA.EnableWindow(true);
	m_BtnStopRT.EnableWindow(false);
	m_BtnStartRT.EnableWindow(false);
}


void CrtpollmfcguiDlg::OnBnClickedCancel()
{
	// Check if RT is running. If yes, abort with a message
	if (!m_BtnInitRT.IsWindowEnabled())
	{
		MessageBox(_T("Cannot close application while channel is in use. Free the channel and retry."), NULL, MB_OK);
	}
	else
	{
		CDialogEx::OnCancel();
	}
}

void CrtpollmfcguiDlg::CreateDisplayString
(
	U32BIT nMsgNum,
	MSGSTRUCT* pMsg,
	CString* pStr
)
{
	U16BIT i;
	char szBuffer[100];
	U16BIT wRT, wTR1, wTR2, wSA, wWC;
	CString tmpStr;

	/* Display message header info */
	tmpStr.Format(_T("\nMSG #%08d.  TIME = %08dus    BUS %c   TYPE%d: %s "), nMsgNum,
		pMsg->wTimeTag * 2, pMsg->wBlkSts & ACE_MT_BSW_CHNL ? 'B' : 'A',
		pMsg->wType, aceGetMsgTypeString(pMsg->wType));
	*pStr += tmpStr;

	/* Display command word info */
	aceCmdWordParse(pMsg->wCmdWrd1, &wRT, &wTR1, &wSA, &wWC);
	sprintf_s(szBuffer, "%02d-%c-%02d-%02d", wRT, wTR1 ? 'T' : 'R', wSA, wWC);
	tmpStr.Format(_T("\n            CMD1 %04X --> %s"), pMsg->wCmdWrd1, szBuffer);
	*pStr += tmpStr;

	tmpStr.Format(_T("\tBSW %04X "), pMsg->wBlkSts);
	*pStr += tmpStr;

	if (pMsg->wCmdWrd2Flg)
	{
		aceCmdWordParse(pMsg->wCmdWrd2, &wRT, &wTR2, &wSA, &wWC);
		sprintf_s(szBuffer, "%02d-%c-%02d-%02d", wRT, wTR2 ? 'T' : 'R', wSA, wWC);
		tmpStr.Format(_T("\n            CMD2 %04X --> %s"), pMsg->wCmdWrd2, szBuffer);
		*pStr += tmpStr;
	}

	/* Display transmit status words */
	if ((wTR1 == 1) || (pMsg->wBlkSts & ACE_MT_BSW_RTRT))
	{
		if (pMsg->wStsWrd1Flg)
		{
			tmpStr.Format(_T("\n            STA1 %04X"), pMsg->wStsWrd1);
			*pStr += tmpStr;
		}
	}

	/* Display Data words */
	for (i = 0; i < pMsg->wWordCount; i++)
	{
		if (i == 0)
		{
			tmpStr.Format(_T("\n            DATA "));
			*pStr += tmpStr;
		}

		tmpStr.Format(_T("%04X  "), pMsg->aDataWrds[i]);
		*pStr += tmpStr;

		if ((i % 8) == 7)
		{
			tmpStr.Format(_T("\n                 "));
			*pStr += tmpStr;
		}
	}

	/* Display receive status words */
	if ((wTR1 == 0) && !(pMsg->wBlkSts & ACE_MT_BSW_RTRT))
	{
		if (pMsg->wStsWrd1Flg)
		{
			tmpStr.Format(_T("\n            STA1 %04X"), pMsg->wStsWrd1);
			*pStr += tmpStr;
		}
	}

	if (pMsg->wStsWrd2Flg)
	{
		tmpStr.Format(_T("\n            STA2 %04X"), pMsg->wStsWrd2);
		*pStr += tmpStr;
	}

	/* Display Error information */
	if (pMsg->wBlkSts & ACE_MT_BSW_ERRFLG)
	{
		tmpStr.Format(_T("\n ERROR: %s\n\n"), aceGetBSWErrString(ACE_MODE_MT, pMsg->wBlkSts));
		*pStr += tmpStr;
	}
}

/*******************************************************************************
 * Name:    OnNewHbufMsgAvailable
 *
 * Description:
 *
 *      This is a user-defined windows message handler for the message
 * WM_PROCESS_NEW_HBUF_MSG_AVLBL. This message is posted by ThreadMsgGet
 * when it finds a message. wParam contains the message number.
 *
 * The handler processes the received message for user-friendly display
 * in the rich edit control
 *
 * In   lpParam: A parameter passed when the thread was created
 * Out  none
 ******************************************************************************/
LRESULT	CrtpollmfcguiDlg::OnNewHbufMsgAvailable(WPARAM wParam, LPARAM lParam)
{
	//UpdateData(true);
	CString displayStr = _T("");
	CString oldDispStr = _T("");

	/* Update display with data from the received message */
//	m_RecMsgDisplay.SetWindowTextW(_T(""));
	CreateDisplayString((int)wParam , &gMsg, &displayStr);
//	m_RecMsgDisplay.SetWindowTextW(displayStr);

	m_RecMsgDisplay.GetWindowTextA(oldDispStr);
	displayStr = oldDispStr + displayStr;
	//m_RecMsgDisplay.SetWindowTextA(_T(""));
	m_RecMsgDisplay.SetWindowTextA(displayStr);

	long textLen = m_RecMsgDisplay.GetTextLength();
	long lineFromChar = m_RecMsgDisplay.LineFromChar(textLen);
	m_RecMsgDisplay.LineScroll(lineFromChar);

	//UpdateData(false);
	return 0;
}

/*******************************************************************************
 * Name:    ThreadMsgGet
 *
 * Description:
 *
 *      A separate thread to read msgs
 *
 * In   lpParam: A parameter passed when the thread was created
 * Out  none
 ******************************************************************************/
DWORD WINAPI ThreadMsgGet(LPVOID lpParam)
{
	CrtpollmfcguiDlg* pDlg = (CrtpollmfcguiDlg*)lpParam;
	S16BIT nResult = 0x0000;
	U32BIT nMsgNum = 0x0000;
	MSGSTRUCT sMsg;

	while (!quitThread)
	{
		/* Check for RT messages */
		nResult = aceRTGetStkMsgDecoded(pDlg->m_LDN, &sMsg, ACE_RT_MSGLOC_NEXT_PURGE);

		/* Message found */
		if (nResult == 1)
		{
			/* Update total messages counter */
			++nMsgNum;

			/* Save message into a global structure array */
			gMsg = sMsg;

			/* Notify GUI thread */
			pDlg->PostMessage(WM_PROCESS_NEW_HBUF_MSG_AVLBL, nMsgNum);
		}

		Sleep(1);
	}

	return 0;
}


void CrtpollmfcguiDlg::OnBnClickedButtonAddSa()
{
	int nSel = m_ListAvlblSA.GetCurSel();
	if (nSel != LB_ERR)
	{
		CString ItemSelected;
		m_ListAvlblSA.GetText(nSel, ItemSelected);
		m_ListUsedSA.AddString(ItemSelected);
		m_ListAvlblSA.DeleteString(nSel);

		SortListbox(&m_ListAvlblSA);
		SortListbox(&m_ListUsedSA);
	}
	else
	{
		AfxMessageBox(_T("Select a SubAddress from the list of 'Available SubAddresses'!"));
	}
}


void CrtpollmfcguiDlg::OnBnClickedButtonRemoveSa()
{
	int nSel = m_ListUsedSA.GetCurSel();
	if (nSel != LB_ERR)
	{
		CString ItemSelected;
		m_ListUsedSA.GetText(nSel, ItemSelected);
		m_ListAvlblSA.AddString(ItemSelected);
		m_ListUsedSA.DeleteString(nSel);

		SortListbox(&m_ListAvlblSA);
		SortListbox(&m_ListUsedSA);
	}
	else
	{
		AfxMessageBox(_T("Select a SubAddress from the list of 'Used SubAddresses'!"));
	}
}

void CrtpollmfcguiDlg::SortListbox(CListBox* pListBox)
{
	CArray<int> arrayOfInts;
	CString itemStr;
	int itemInt;

	for (int itemNo = 0; itemNo < pListBox->GetCount(); itemNo++)
	{
		pListBox->GetText(itemNo, itemStr);
		arrayOfInts.Add(_ttoi(itemStr));
	}

	std::sort(arrayOfInts.GetData(), arrayOfInts.GetData() + arrayOfInts.GetSize());

	pListBox->ResetContent();

	for (int itemNo = 0; itemNo < arrayOfInts.GetCount(); itemNo++)
	{
		itemInt = arrayOfInts.GetAt(itemNo);
		itemStr.Format("%d", itemInt);
		pListBox->AddString(itemStr);
	}
}


void CrtpollmfcguiDlg::OnBnClickedButtonWrite()
{
	U16BIT wBuffer[32];

	// Validate the data value entered by the user 
	UpdateData(TRUE);
	if ((m_DataToWrite < 0) || m_DataToWrite > 0xFFFF) // Valid values are 0 to 65535
	{
		MessageBox(_T("Value out of range!"), NULL, MB_OK);
		m_editDataToWrite.SetFocus();
		return;
	}

	int intSA;
	int nSel = m_ListUsedTxSA.GetCurSel();
	if (nSel != LB_ERR)
	{
		CString ItemSelected;
		m_ListUsedTxSA.GetText(nSel, ItemSelected);
		intSA = _ttoi(ItemSelected);
	}
	else
	{
		AfxMessageBox(_T("Select a Tx SubAddress from the list of 'Used SubAddresses'!"));
		return;
	}

	// Populate a 32 word buffer with data input by the user
	for (int i = 0; i < 32; i++)
	{
		wBuffer[i] = (U16BIT)m_DataToWrite;
	}

	// call aceRTDataBlkWrite to write the data to the data block
	//S16BIT wResult = aceRTDataBlkWrite(m_LDN, DBLK3, wBuffer, 32, 0);
	S16BIT wResult = aceRTDataBlkWrite(m_LDN, TX_DBLK_BASE + intSA, wBuffer, 32, 0);
	if (wResult)
	{
		MessageBox(_T("aceRTDataBlkWrite Failed"), NULL, MB_OK);
		return;
	}
}


void CrtpollmfcguiDlg::OnBnClickedButtonAddTxSa()
{
	int nSel = m_ListAvlblTxSA.GetCurSel();
	if (nSel != LB_ERR)
	{
		CString ItemSelected;
		m_ListAvlblTxSA.GetText(nSel, ItemSelected);
		m_ListUsedTxSA.AddString(ItemSelected);
		m_ListAvlblTxSA.DeleteString(nSel);

		SortListbox(&m_ListAvlblTxSA);
		SortListbox(&m_ListUsedTxSA);
	}
	else
	{
		AfxMessageBox(_T("Select a SubAddress from the list of 'Available SubAddresses'!"));
	}
}


void CrtpollmfcguiDlg::OnBnClickedButtonRemoveTxSa()
{
	int nSel = m_ListUsedTxSA.GetCurSel();
	if (nSel != LB_ERR)
	{
		CString ItemSelected;
		m_ListUsedTxSA.GetText(nSel, ItemSelected);
		m_ListAvlblTxSA.AddString(ItemSelected);
		m_ListUsedTxSA.DeleteString(nSel);

		SortListbox(&m_ListAvlblTxSA);
		SortListbox(&m_ListUsedTxSA);
	}
	else
	{
		AfxMessageBox(_T("Select a SubAddress from the list of 'Used SubAddresses'!"));
	}
}
